﻿using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using System.Windows.Forms;
using System.Net;
using Inet.Viewer;
using Inet.Viewer.Data;
using System.Threading;
using Inet.Viewer.test.WinForms;


namespace Inet.Viewer.WinForms
{
    [TestFixture]
    class TestReportView
    {        
        private const string inValidUrl =                   "http://";
        public const string inValidReport =                 "http://dell28:9000/?report=repo:%2FsVeryRandomReportThatCannotEcist.rpt";
        private const string validServerUrl = "http://dell28:9000/?report=repo:/test/DotNetViewer4Pages.rpt";
        private const string validServerUrlWithParameters = "http://dell28:9000/?report=repo:/test/DotNetViewer4Pages.rpt&hasgrouptree=false&promptonrefresh=true";
        private const string validSubreportOnDemand =       "http://dell28:9000/?init=html&report=repo%3a%2ftest%2ffeature%2freports%2fsubreports%2fsubreport3.rpt&locale=de&subreport_ondemand=type%3d0%26subreport%3d0";
        private const string validPrompts =                 "http://dell28:9000/?report=repo:%2Fstatistik%2Fticketstatistik.rpt";

        
        [Test]
        public void TestInvalidServerReport()
        {
            URLRenderData data = new URLRenderData();

            data = new URLRenderData();
            data.ReportLocation = inValidReport;
            try
            {
                ReportViewShowError view = new ReportViewShowError(data);
                Assert.Fail("Exception expected");
            }
            catch (ViewerException ex)
            {
                Assert.NotNull(ex.ServerStackTrace);
            }
        }

        [Test]        
        public void TestInvalidServerUrl()
        {
            IRenderData data = new URLRenderData();
            try
            {
                data.ReportLocation = inValidUrl;
                Assert.Fail("Should bring an Exception");
            }
            catch (Exception)
            {
                Assert.Pass("Should throw this UriFormatException");            
            }
        }        

      
        [Test]        
        public void TestReportViewData()
        {
            IRenderData data = new URLRenderData();
            data.ReportLocation = validServerUrl;

            ReportViewShowError view = new ReportViewShowError(data);
            Assert.AreEqual(4, view.PageCount, "The Maximum Page was not loaded correctly");        
        }

                        
        [Test]
        public void TestReportWithParameter()
        {
            // Link with no parameters
            IRenderData data = new URLRenderData();
            data.ReportLocation = validServerUrl;

            ReportViewShowError view = new ReportViewShowError(data);

            // TODO (test) #51051 implement
            //Assert.IsFalse(view.PromptsOnRefresh, "No PromptOnRefresh");
            
            // Link with parameters
            data = new URLRenderData();
            data.ReportLocation = validServerUrlWithParameters;
            view = new ReportViewShowError(data);

            // TODO (test) #51051 Assert.IsTrue(view.PromptsOnRefresh, "PromptOnRefresh");

            // test wrong init
            data = new URLRenderData();
            data.ReportLocation = validServerUrlWithParameters + "&init=html";
            view = new ReportViewShowError(data);

            // test wrong init
            data = new URLRenderData();
            data.ReportLocation = validServerUrlWithParameters + "&init=png";
            view = new ReportViewShowError(data);

            // Show report and export
            data = new URLRenderData();
            data.ReportLocation = validServerUrlWithParameters;

            data.ReportLocation = validServerUrlWithParameters + "&hasexportbutton=false&hasrefreshbutton=false";
            view = new ReportViewShowError(data);
        }

        /* TODO (test) check this report on local server first
        [Test]
        public void TestReportWithSubreportOnDemand()
        {
            URLRenderData data = new URLRenderData(validSubreportOnDemand);
            ReportView view = new ReportView(data);
        }
        */

        [Test]
        public void TestReportWithPrompts()
        {
            try
            {
                URLRenderData data = new URLRenderData(validPrompts);
                ReportViewShowError view = new ReportViewShowError(data);
                Assert.Fail("NeedsPrompts Exception should be thrown");
            }
            catch (ViewerException e)
            {
                Assert.IsTrue(e.NeedPrompts, "NeedsPrompts");
                Assert.IsTrue(e.Message.Contains("NeedsPrompts"), "Message contains prompts");
                Assert.AreEqual(3, e.Prompts.Length, "Length");

                PromptData prompt1 = e.Prompts[0];
                Assert.AreEqual("Start der Testwoche", prompt1.Name);
                Assert.AreEqual(PromptData.Date, prompt1.Type);
                Assert.IsInstanceOf<RangePromptValue>(prompt1.Values);
                SinglePromptValue value = ((RangePromptValue)prompt1.Values).StartValue;

                DateTime d = DateTime.Now.Date;
                while (d.DayOfWeek != DayOfWeek.Monday)
                {
                    d -= new TimeSpan(1, 0, 0, 0);
                }
                Assert.AreEqual(d, value.Value, "date value");
                Assert.AreEqual(d.ToShortDateString(), value.ValueString, "value string");
                Assert.AreEqual("Date(" + d.Year + "," + d.Month + "," + d.Day + ")", value.StringRepresentation, "value StringRepresentation");

                PromptData prompt2 = e.Prompts[1];
                Assert.AreEqual("Owner ist Reporter ausblenden", prompt2.Name);
                Assert.AreEqual(PromptData.Boolean, prompt2.Type);

                PromptData prompt3 = e.Prompts[2];
                Assert.AreEqual("Mit CodeQualität und Tests", prompt3.Name);
                Assert.AreEqual(PromptData.Boolean, prompt3.Type);
            }
        }


        [Test]
        public void TestReportTitleCustom()
        {
            IRenderData data = new URLRenderData();
            data.ReportLocation = validServerUrl;

            ReportViewShowError view = new ReportViewShowError(data, false);
            view.ReportTitle = "MyTestReportTitle";

            view.AssertException(3);
            Assert.AreEqual("MyTestReportTitle", view.ReportTitle, "The title should not change with a page request and refresh=true");

            //view.RefreshWithPage(1, true);
            //Assert.AreEqual("MyTestReportTitle", view.ReportTitle, "The title should not change with a refresh");
        }


        [Test]
        public void TestPropertiesBeforeUIHandler()
        {
            IRenderData data = new URLRenderData();
            data.ReportLocation = validServerUrl;

            ReportViewShowError view = new ReportViewShowError();
            view.ReportData = data;
            Assert.NotNull(view.ReportDataCache);
            var reportInfo = new ReportInfo();
            reportInfo.FileName = "filename.123";
            view.ReportInfo = reportInfo;
            Assert.AreEqual("filename.123",view.ReportInfo.FileName);
            view.CurrentPage = 10;
            Assert.AreEqual(10, view.CurrentPage);
            view.ViewMode = PageViewMode.DoubleContinuous;
            Assert.AreEqual(PageViewMode.DoubleContinuous, view.ViewMode);
        }
    }
}

